/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities.royal_guard;

import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.entities.effects.AttackEffects;
import com.pikachu.mod.illager_more.entities.royal_guard.RoyalGuardTypesEntity;
import com.pikachu.mod.illager_more.init.ModEntityTypes;
import com.pikachu.mod.illager_more.init.ModItems;
import com.pikachu.mod.illager_more.init.ModSounds;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class RoyalGuardEntities {

    static class DoHurtTargetGoal
    extends Goal {
        protected final RoyalGuardBase mob;
        protected int type;
        protected boolean canMoving;
        protected boolean hasNext;

        public DoHurtTargetGoal(RoyalGuardBase entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (Boolean)this.mob.m_20088_().m_135370_(RoyalGuardBase.CAN_MELEE) != false && this.mob.m_5448_() != null;
        }

        public boolean m_8045_() {
            if (!this.hasNext) {
                return this.isAttacking();
            }
            if (!this.isAttacking()) {
                this.mob.timer = 0;
                ++this.type;
                return this.mob.m_5448_() != null && this.mob.m_5448_().f_20916_ > 0;
            }
            return true;
        }

        protected boolean isAttacking() {
            return this.mob.timer < this.getAnimationTick();
        }

        protected int getAnimationTick() {
            return 16;
        }

        protected int getAnimationActionTick() {
            return 9;
        }

        public boolean m_6767_() {
            return this.mob.f_20916_ > 0 && this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) < 6.0f;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.type = 1;
            this.mob.m_20088_().m_135381_(RoyalGuardBase.IS_MELEE, (Object)true);
            this.mob.m_20088_().m_135381_(RoyalGuardBase.CAN_MELEE, (Object)false);
            this.mob.m_20088_().m_135381_(RoyalGuardBase.MELEE_TYPE, (Object)11);
            this.mob.m_5496_((SoundEvent)ModSounds.VINDICATOR_ATTACK.get(), 1.0f, 1.0f);
        }

        public void m_8037_() {
            ++this.mob.timer;
            this.mob.m_20334_(0.0, this.mob.m_20184_().f_82480_, 0.0);
            this.attack(this.getAnimationActionTick());
            this.moving(6);
            if (!this.canMoving) {
                this.mob.m_21573_().m_26573_();
            }
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
                if (this.canMoving) {
                    this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), 1.0);
                }
            }
            this.mob.m_20088_().m_135381_(RoyalGuardBase.MELEE_TYPE, (Object)this.type);
        }

        protected void attack(int i) {
            if (this.mob.timer == i) {
                this.mob.m_5496_((SoundEvent)ModSounds.ROYAL_GUARD_ATTACK.get(), 2.0f, 1.5f);
                CombatEvent.AreaAttack((LivingEntity)this.mob, 3.5f, 3.5f, 3.5f, 3.5f, 180.0f, 0.8f, 0.0, 0.5, false);
                this.canMoving = false;
            }
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.m_20088_().m_135381_(RoyalGuardBase.IS_MELEE, (Object)false);
            float dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 150.0f - 75.0f);
            this.mob.m_21561_(this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_());
        }

        protected void moving(int i) {
            if (this.mob.timer == i) {
                this.mob.m_20256_(this.mob.m_20184_().m_82520_((this.mob.m_5448_().m_20185_() - this.mob.m_20185_()) / Math.PI, 0.0, (this.mob.m_5448_().m_20189_() - this.mob.m_20189_()) / Math.PI));
            }
        }
    }

    static class GuardAttackGoal
    extends MeleeAttackGoal {
        protected final RoyalGuardBase mobEntity;

        public GuardAttackGoal(RoyalGuardBase p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            super((PathfinderMob)p_i1636_1_, p_i1636_2_, p_i1636_4_);
            this.mobEntity = p_i1636_1_;
        }

        public void m_8041_() {
            super.m_8041_();
            this.f_25540_.m_21561_(this.f_25540_.m_5448_() != null && this.f_25540_.m_5448_().m_6084_());
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d = distToEnemySqr + 18.0 + (double)enemy.m_20205_();
            int n = (double)this.f_25540_.m_21223_() >= (double)this.f_25540_.m_21233_() / 1.3 ? 120 : 0;
            if ((d + (double)n <= (double)this.mobEntity.m_20270_((Entity)enemy) || this.mobEntity.m_20191_().m_82381_(enemy.m_20191_().m_82400_(2.0)) || this.mobEntity.m_20191_().m_82381_(enemy.m_20191_().m_82377_(2.0, 2.0, 2.0))) && this.m_25565_() <= 0 && (!this.mobEntity.m_21254_() || this.mobEntity.m_21254_() && this.mobEntity.m_217043_().m_188503_(60) == 0 || this.mobEntity.m_21254_() && this.mobEntity.m_217043_().m_188503_(10) == 0 && this.mobEntity.f_19802_ > 0)) {
                this.mobEntity.m_20088_().m_135381_(RoyalGuardBase.CAN_MELEE, (Object)true);
                this.m_25563_();
            }
        }

        protected int m_183277_(int p_186072_) {
            return 20;
        }
    }

    public static abstract class RoyalGuardBase
    extends AbstractIllager
    implements RoyalGuardTypesEntity {
        protected static final UUID SPEED_MODIFIER_BLOCKING_UUID = UUID.fromString("01cd373b-0ff1-4ded-8630-b380232ed7b1");
        protected static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_BLOCKING_UUID, "Running speed increase", -0.1, AttributeModifier.Operation.ADDITION);
        protected static final EntityDataAccessor<Boolean> CAN_MELEE = SynchedEntityData.m_135353_(RoyalGuardBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        protected static final EntityDataAccessor<Boolean> IS_MELEE = SynchedEntityData.m_135353_(RoyalGuardBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        protected static final EntityDataAccessor<Integer> MELEE_TYPE = SynchedEntityData.m_135353_(RoyalGuardBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        protected AbstractIllager leaderOfTheTeam = null;
        protected boolean isLeaderOfTheTeam = false;
        protected boolean isNoDamages = false;
        protected byte attackType = 0;
        protected int shieldCooldownTime = 0;
        protected int timer = 0;
        protected ItemLike helmet;
        protected ItemLike chestplate;
        protected ItemLike leggings;
        protected ItemLike boots;
        protected ItemLike mainHand;
        protected ItemLike offHand;

        protected RoyalGuardBase(EntityType<? extends AbstractIllager> p_32105_, Level p_32106_) {
            super(p_32105_, p_32106_);
            this.f_21364_ = 15;
            this.helmet = null;
            this.chestplate = null;
            this.leggings = null;
            this.boots = null;
            this.mainHand = null;
            this.offHand = null;
        }

        protected ItemStack getDefaultItem(EquipmentSlot equipmentSlot) {
            ItemStack itemStack = null;
            if (equipmentSlot == EquipmentSlot.HEAD) {
                itemStack = new ItemStack(this.helmet);
            }
            if (equipmentSlot == EquipmentSlot.CHEST) {
                itemStack = new ItemStack(this.chestplate);
            }
            if (equipmentSlot == EquipmentSlot.LEGS) {
                itemStack = new ItemStack(this.leggings);
            }
            if (equipmentSlot == EquipmentSlot.FEET) {
                itemStack = new ItemStack(this.boots);
            }
            if (equipmentSlot == EquipmentSlot.MAINHAND) {
                itemStack = new ItemStack(this.mainHand);
            }
            if (equipmentSlot == EquipmentSlot.OFFHAND) {
                itemStack = new ItemStack(this.offHand);
            }
            return itemStack;
        }

        public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
            return false;
        }

        public boolean m_7307_(Entity p_33314_) {
            if (super.m_7307_(p_33314_)) {
                return true;
            }
            if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == MobType.f_21643_) {
                return this.m_5647_() == null && p_33314_.m_5647_() == null;
            }
            return false;
        }

        @Nullable
        public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack itemStack = this.getDefaultItem(equipmentSlot);
                if (itemStack == null) continue;
                this.m_8061_(equipmentSlot, itemStack);
            }
            return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
        }

        public void m_8119_() {
            super.m_8119_();
        }

        public static AttributeSupplier.Builder createAttributes() {
            return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.265f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 0.35).m_22268_(Attributes.f_22281_, 2.5);
        }

        protected void m_8099_() {
            super.m_8099_();
            this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
            this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
            this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
            this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
            this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
            this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
            this.registerAttackGoal();
        }

        protected void registerAttackGoal() {
            this.f_21345_.m_25352_(0, (Goal)new DoHurtTargetGoal(this));
            this.f_21345_.m_25352_(4, (Goal)new GuardAttackGoal(this, 1.1f, true));
        }

        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(CAN_MELEE, (Object)false);
            this.f_19804_.m_135372_(IS_MELEE, (Object)false);
            this.f_19804_.m_135372_(MELEE_TYPE, (Object)0);
        }

        @Override
        public AbstractIllager getLeader() {
            return this.leaderOfTheTeam;
        }

        @Override
        public boolean canBeTeamLeader() {
            return false;
        }

        @Override
        public int getShieldCooldownTime() {
            return this.shieldCooldownTime;
        }

        @Override
        public byte getLeaderAttackType() {
            return ((RoyalGuardTypesEntity)this.leaderOfTheTeam).getAttackType();
        }

        @Override
        public byte getAttackType() {
            return this.attackType;
        }

        @Override
        public void setShieldCooldownTime(int shieldCooldownTime) {
            this.shieldCooldownTime = shieldCooldownTime;
        }

        @Override
        public void disableShield(boolean guaranteeDisable) {
            float f = 0.45f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (guaranteeDisable) {
                f += 0.55f;
            }
            if (this.f_19796_.m_188501_() < f) {
                this.setShieldCooldownTime(100);
                this.m_5810_();
                this.f_19853_.m_7605_((Entity)this, (byte)30);
            }
        }

        public void m_7895_(int p_37844_, boolean p_37845_) {
        }

        @Nonnull
        public SoundEvent m_7930_() {
            return SoundEvents.f_12577_;
        }

        protected SoundEvent m_7515_() {
            return SoundEvents.f_12576_;
        }

        protected SoundEvent m_5592_() {
            return SoundEvents.f_12578_;
        }

        protected SoundEvent m_7975_(@Nonnull DamageSource p_184601_1_) {
            return SoundEvents.f_12579_;
        }

        @Override
        public boolean canUseShield() {
            return true;
        }

        protected void m_6728_(LivingEntity p_21200_) {
            super.m_6728_(p_21200_);
            this.breakShield((LivingEntity)this, p_21200_);
        }

        protected void m_7909_(float p_21316_) {
            super.m_7909_(p_21316_);
            this.shieldHurt(p_21316_, (LivingEntity)this);
        }

        protected void m_6677_(DamageSource p_21493_) {
            this.hurtSound(p_21493_, (LivingEntity)this, this.m_7975_(p_21493_));
        }

        protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
            this.m_5496_((SoundEvent)ModSounds.ROYAL_GUARD_STEP.get(), 0.75f, 1.0f);
        }
    }

    public static class RoyalGuardSpear
    extends RoyalGuardBase
    implements IAnimatable {
        AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

        public RoyalGuardSpear(EntityType<? extends AbstractIllager> p_32105_, Level p_32106_) {
            super(p_32105_, p_32106_);
            this.helmet = (ItemLike)ModItems.ROYAL_GUARD_SPEAR_HELMET.get();
            this.chestplate = (ItemLike)ModItems.ROYAL_GUARD_SPEAR_CHESTPLATE.get();
            this.leggings = (ItemLike)ModItems.ROYAL_GUARD_SPEAR_LEGGINGS.get();
            this.boots = (ItemLike)ModItems.ROYAL_GUARD_SPEAR_BOOTS.get();
            this.mainHand = (ItemLike)ModItems.ROYAL_GUARD_SPEAR.get();
        }

        @Override
        protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
            this.m_5496_(SoundEvents.f_11677_, 0.875f, 1.0f);
        }

        public static AttributeSupplier.Builder createAttributes() {
            return RoyalGuardBase.createAttributes().m_22268_(Attributes.f_22276_, 36.0).m_22268_(Attributes.f_22282_, 2.3).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.25);
        }

        public void registerControllers(AnimationData data) {
            data.addAnimationController(new AnimationController((IAnimatable)this, "r", 0.0f, this::rot));
            data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
        }

        @Override
        protected void registerAttackGoal() {
            this.f_21345_.m_25352_(0, (Goal)new DoHurtTargetGoal(this){

                @Override
                public void m_8041_() {
                    this.mob.timer = 0;
                    this.mob.m_20088_().m_135381_(RoyalGuardBase.IS_MELEE, (Object)false);
                    this.mob.m_21561_(this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_());
                }

                @Override
                protected void moving(int i) {
                }

                @Override
                protected int getAnimationActionTick() {
                    return 30;
                }

                @Override
                protected int getAnimationTick() {
                    return 17;
                }

                @Override
                public void m_8056_() {
                    super.m_8056_();
                    this.type = 4;
                }

                @Override
                public void m_8037_() {
                    ++this.mob.timer;
                    this.mob.m_20334_(0.0, this.mob.m_20184_().f_82480_, 0.0);
                    if (this.type == 1) {
                        this.attack(14);
                        this.hasNext = true;
                    } else if (this.type == 2) {
                        this.attack(11);
                        this.hasNext = true;
                    } else if (this.type == 3) {
                        this.attack(12);
                        this.hasNext = false;
                    } else if (this.type == 4) {
                        this.attack(11);
                        this.hasNext = false;
                    }
                    if (this.mob.m_5448_() == null) {
                        this.hasNext = false;
                    }
                    if (!this.canMoving) {
                        this.mob.m_21573_().m_26573_();
                    }
                    if (this.mob.m_5448_() != null) {
                        this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
                        if (this.canMoving) {
                            this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), 1.0);
                        }
                    }
                    this.mob.m_20088_().m_135381_(RoyalGuardBase.MELEE_TYPE, (Object)this.type);
                }

                @Override
                protected void attack(int i) {
                    if (this.mob.timer == i - 3) {
                        float rot = this.type == 1 ? -175.0f : (this.type == 2 ? -5.0f : (this.type == 3 ? -172.0f : 90.0f));
                        AttackEffects e = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, rot, 1.1f, 3.0f, 2);
                        e.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.35, 1.835, this.mob.f_20883_));
                        e.setCaster((LivingEntity)this.mob);
                        e.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 5.335, this.mob.f_20883_));
                        e.m_146922_(-(e.m_146908_() % 360.0f) - 90.0f);
                        this.mob.f_19853_.m_7967_((Entity)e);
                    }
                    if (this.type <= 3) {
                        if (this.mob.timer == i) {
                            this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.5f);
                            CombatEvent.AreaAttack((LivingEntity)this.mob, 5.5f, 5.5f, 0.5f, 5.5f, 220.0f, 0.675f, 0.0, 1.0, false);
                            this.canMoving = false;
                            this.hasNext = this.mob.m_5448_() != null && this.mob.m_5448_().f_20916_ > 0 && this.type <= 3;
                        }
                    } else if (this.mob.timer == i) {
                        this.mob.m_5496_(SoundEvents.f_11669_, 0.73f, 1.5f);
                        CombatEvent.AreaAttack((LivingEntity)this.mob, 5.5f, 5.5f, 0.5f, 5.5f, 220.0f, 1.2f, 0.3675, 0.3, true);
                        this.canMoving = false;
                        this.hasNext = false;
                    }
                }
            });
            this.f_21345_.m_25352_(4, (Goal)new GuardAttackGoal(this, 1.1f, true){

                @Override
                protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
                    double d = distToEnemySqr + 36.0 + (double)enemy.m_20205_();
                    int n = (double)this.f_25540_.m_21223_() >= (double)this.f_25540_.m_21233_() / 1.3 ? 120 : 0;
                    if ((d + (double)n <= (double)this.mobEntity.m_20270_((Entity)enemy) || this.mobEntity.m_20191_().m_82381_(enemy.m_20191_().m_82400_(2.0)) || this.mobEntity.m_20191_().m_82381_(enemy.m_20191_().m_82377_(2.0, 2.0, 2.0))) && this.m_25565_() <= 0 && (!this.mobEntity.m_21254_() || this.mobEntity.m_21254_() && this.mobEntity.m_217043_().m_188503_(60) == 0 || this.mobEntity.m_21254_() && this.mobEntity.m_217043_().m_188503_(10) == 0 && this.mobEntity.f_19802_ > 0)) {
                        this.mobEntity.m_20088_().m_135381_(RoyalGuardBase.CAN_MELEE, (Object)true);
                        this.m_25563_();
                    }
                }
            });
        }

        private <P extends IAnimatable> PlayState rot(AnimationEvent<P> event) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot3", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }

        private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
            event.getController().setAnimationSpeed(1.0);
            RoyalGuardSpear livingEntity = this;
            Vec3 velocity = livingEntity.m_20184_();
            float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
            if (((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue()) {
                event.getController().setAnimationSpeed(1.0);
                event.getController().setAnimation(new AnimationBuilder().addAnimation("h_a", Boolean.valueOf(true)));
            } else if (this.m_5912_()) {
                if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                    event.getController().setAnimationSpeed(Math.max(Math.min((double)(groundSpeed * 10.0f), 2.1), 0.15));
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
                }
            } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimationSpeed(Math.max(Math.min((double)(groundSpeed * 10.0f), 2.1), 0.15));
                event.getController().setAnimation(new AnimationBuilder().addAnimation("walk_no_target", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("idle_no_target", Boolean.valueOf(true)));
            }
            if (!this.m_6084_()) {
                event.getController().setAnimationSpeed(1.0E-5);
            }
            return PlayState.CONTINUE;
        }

        public AnimationFactory getFactory() {
            return this.factory;
        }
    }
}

